/*
 * Decompiled with CFR 0.152.
 */
package com.dfdyz.epicacg.client.render.custom;

import com.dfdyz.epicacg.client.render.pipeline.PostEffectPipelines;
import com.dfdyz.epicacg.client.render.pipeline.PostParticleRenderType;
import com.dfdyz.epicacg.client.render.targets.ScaledTarget;
import com.dfdyz.epicacg.config.ClientConfig;
import com.dfdyz.epicacg.registry.PostEffects;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class BloomParticleRenderType
extends PostParticleRenderType {
    static final PostEffectPipelines.Pipeline ppl = new Pipeline(new ResourceLocation("epicacg", "bloom_particle"));

    public BloomParticleRenderType(ResourceLocation renderTypeID, ResourceLocation tex) {
        super(renderTypeID, tex);
    }

    @Override
    public PostEffectPipelines.Pipeline getPipeline() {
        return ppl;
    }

    private static int NumMul(int a, float b) {
        return (int)((float)a * Math.max(Math.min(b, 1.5f), 0.8f));
    }

    public static class Pipeline
    extends PostEffectPipelines.Pipeline {
        RenderTarget[] blur;
        RenderTarget[] blur_;
        RenderTarget temp;

        public Pipeline(ResourceLocation name) {
            super(name);
        }

        void handlePasses(RenderTarget src) {
            RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            if (ClientConfig.cfg.BloomMode == 0) {
                PostEffects.downSampler.process(src, this.blur[0]);
                PostEffects.downSampler.process(this.blur[0], this.blur[1]);
                PostEffects.downSampler.process(this.blur[1], this.blur[2]);
                PostEffects.downSampler.process(this.blur[2], this.blur[3]);
                PostEffects.downSampler.process(this.blur[3], this.blur[4]);
                PostEffects.upSampler.process(this.blur[4], this.blur_[3], this.blur[3]);
                PostEffects.upSampler.process(this.blur_[3], this.blur_[2], this.blur[2]);
                PostEffects.upSampler.process(this.blur_[2], this.blur_[1], this.blur[1]);
                PostEffects.upSampler.process(this.blur_[1], this.blur_[0], this.blur[0]);
                PostEffects.unity_composite.process(this.blur_[0], this.temp, src, Minecraft.m_91087_().m_91385_());
                PostEffects.blit.process(this.temp, Minecraft.m_91087_().m_91385_());
            } else {
                PostEffects.blur.process(src, this.blur[0], 1.0f, 0.0f, 3);
                PostEffects.blur.process(this.blur[0], this.blur_[0], 0.0f, 1.0f, 3);
                PostEffects.blur.process(this.blur_[0], this.blur[1], 1.0f, 0.0f, 5);
                PostEffects.blur.process(this.blur[1], this.blur_[1], 1.0f, 0.0f, 5);
                PostEffects.blur.process(this.blur_[1], this.blur[2], 1.0f, 0.0f, 7);
                PostEffects.blur.process(this.blur[2], this.blur_[2], 1.0f, 0.0f, 7);
                PostEffects.blur.process(this.blur_[2], this.blur[3], 1.0f, 0.0f, 9);
                PostEffects.blur.process(this.blur[3], this.blur_[3], 1.0f, 0.0f, 9);
                PostEffects.ue_composite.process(src, this.temp, this.blur_[0], this.blur_[1], this.blur_[2], this.blur_[3]);
                PostEffects.blit.process(this.temp, Minecraft.m_91087_().m_91385_());
            }
        }

        void initTargets() {
            int i;
            float s;
            int cnt = 5;
            if (this.blur == null) {
                this.blur = new RenderTarget[cnt];
                s = 1.0f;
                for (i = 0; i < this.blur.length; ++i) {
                    this.blur[i] = new ScaledTarget(s /= 2.0f, s, this.bufferTarget.f_83915_, this.bufferTarget.f_83916_, false, Minecraft.f_91002_);
                    this.blur[i].m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
                    this.blur[i].m_83954_(Minecraft.f_91002_);
                    if (!this.bufferTarget.isStencilEnabled()) continue;
                    this.blur[i].enableStencil();
                }
            }
            if (this.blur_ == null) {
                this.blur_ = new RenderTarget[cnt - 1];
                s = 1.0f;
                for (i = 0; i < this.blur_.length; ++i) {
                    this.blur_[i] = new ScaledTarget(s /= 2.0f, s, this.bufferTarget.f_83915_, this.bufferTarget.f_83916_, false, Minecraft.f_91002_);
                    this.blur_[i].m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
                    this.blur_[i].m_83954_(Minecraft.f_91002_);
                    if (!this.bufferTarget.isStencilEnabled()) continue;
                    this.blur[i].enableStencil();
                }
            }
            if (this.temp == null) {
                this.temp = PostParticleRenderType.createTempTarget(this.bufferTarget);
            }
            if (this.temp.f_83915_ != this.bufferTarget.f_83915_ || this.temp.f_83916_ != this.bufferTarget.f_83916_) {
                int i2;
                for (i2 = 0; i2 < this.blur.length; ++i2) {
                    this.blur[i2].m_83941_(this.bufferTarget.f_83915_, this.bufferTarget.f_83916_, Minecraft.f_91002_);
                }
                for (i2 = 0; i2 < this.blur_.length; ++i2) {
                    this.blur_[i2].m_83941_(this.bufferTarget.f_83915_, this.bufferTarget.f_83916_, Minecraft.f_91002_);
                }
                this.temp.m_83941_(this.bufferTarget.f_83915_, this.bufferTarget.f_83916_, Minecraft.f_91002_);
            }
        }

        @Override
        public void PostEffectHandler() {
            this.initTargets();
            this.handlePasses(this.bufferTarget);
        }
    }
}

